#include <iostream>
#include <vector>
#include <algorithm>
#include <unordered_map>

using namespace std;

class ST {
  private:
    int n;
    vector<int> data;
    vector<int> vec;

    int left(int i){
      return i * 2 + 1;
    }

    int right(int i){
      return i * 2 + 2;
    }

    void _build(int i, int l, int r){
      if (l == r){
        vec[i] = data[l];
        return;
      }

      int m = (l + r) / 2;

      _build(left(i), l, m);
      _build(right(i), m + 1, r);

      vec[i] = vec[left(i)] + vec[right(i)];
    }

    int _sum(int i, int nl, int nr, int l, int r){
      if (r < nl || l > nr){
        return 0;
      }

      if (nl == l && nr == r){
        return vec[i];
      }

      int m = (nl + nr) / 2;
      return _sum(left(i), nl, m, l, min(m, r)) + _sum(right(i), m + 1, nr, max(m + 1, l), r);
    }

    void _add(int i, int target, int amount, int nl, int nr){
      if (target < nl || target > nr)
        return;

      if (nl == nr){
        vec[i] += amount;
        return;
      }


      int m = (nl + nr) / 2;
      _add(left(i), target, amount, nl, m);
      _add(right(i), target, amount, m + 1, nr);

      vec[i] = vec[left(i)] + vec[right(i)];
    }
  public:
    ST(const vector<int>& v): n(v.size()), data(v) {
      vec.assign(n * 4, 0);
      _build(0, 0, n - 1);
    }

    int sum(int l, int r){
      return _sum(0, 0, n - 1, l, r);
    }

    void add(int i, int x){
      _add(0, i, x, 0, n - 1);
    }
};

int main(){
  ios_base::sync_with_stdio(false), cin.tie(0);

  int n,q;cin>>n>>q;

  unordered_map<int, int> index;
  vector<int> a(n);

  for (int i = 0; i < n; ++i){
    int x;cin>>x;

    if (index[x]){
      a[i] = 0;
      a[index[x] - 1] += x;
    }
    else{
      index[x] = i + 1;
      a[i] = x;
    }
  }

  vector<int> sortedWeights;

  for (int i = 0; i < n; ++i){
    if (a[i])
      sortedWeights.push_back(a[i]);
  }

  sort(sortedWeights.begin(), sortedWeights.end());

  ST sum(sortedWeights);

  for (int i = 0; i < q; ++i){
    int t;cin>>t;

    if (t == 1){
      int x;cin>>x;
      int r = n - x;
      int s = sortedWeights.size() - r <= 0 ? 0 : sum.sum(0, sortedWeights.size() - r - 1);

      cout<<s<<'\n';
    }else{
      
    }
  }

  return 0;
}